/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service.issue.change_processors;

import io.jsonwebtoken.lang.Strings;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import systems.dennis.flaw.bean.TelegramBotBean;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.issue.AbstractIssueChangedProcess;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;

/*
 * Exception performing whole class analysis ignored.
 */
public class TelegramBotProcessor
extends AbstractIssueChangedProcess {
    public boolean run(IssueModel origin, IssueModel target, WebContext.LocalWebContext context) {
        String text;
        String string = text = origin == null ? this.generateTelegramChangesAdd(target, context) : this.generateTelegramChangesEdit(origin, target, context);
        if (text != null) {
            ((TelegramBotBean)context.getBean(TelegramBotBean.class)).sendMessage(target.getGroup(), text);
        }
        return true;
    }

    public boolean shouldExecute(IssueModel origin, IssueModel target, WebContext.LocalWebContext context) {
        return ((TelegramBotBean)context.getBean(TelegramBotBean.class)).isActive() && target.getGroup().getTelegramId() != null && target.getGroup().getTelegramId() != 0L;
    }

    private String generateTelegramChangesAdd(IssueModel current, WebContext.LocalWebContext context) {
        StringBuffer issue = new StringBuffer();
        issue.append("<a href='").append(TelegramBotProcessor.getIssuePath((WebContext.LocalWebContext)context, (IssueModel)current)).append("'>Issue: ID").append(current.getId()).append("</a> was created: \n");
        issue.append("Name: ").append(current.getName()).append("\n");
        issue.append("Attention to: ").append(this.generateAttentionUsers(current)).append("\n");
        StringBuilder changes = new StringBuilder();
        changes.append("Priority: ").append(this.toStr((BaseEntity)current.getPriority())).append("\n");
        changes.append("Tester: ").append(this.toStr((BaseEntity)current.getTester())).append("\n");
        changes.append("Performer: ").append(this.toStr((BaseEntity)current.getPerformer())).append("\n");
        changes.append("Status: ").append(this.toStr((BaseEntity)current.getStatus())).append("\n");
        if (Objects.equals(current.getIcon(), "")) {
            changes.append("Screenshot: ").append("Not set").append("\n");
        } else {
            changes.append("Screenshot: ").append(current.getIcon()).append("\n");
        }
        return changes.toString().isEmpty() ? null : issue.append((CharSequence)changes).append("Issue was created by ").append(((HRService)context.getBean(HRService.class)).me().getName()).toString();
    }

    public String generateAttentionUsers(IssueModel issue) {
        HashSet<String> elements = new HashSet<String>();
        if (issue.getCreator() != null) {
            elements.add(TelegramBotProcessor.createTelegramUser((HRModel)issue.getCreator()));
        }
        if (issue.getTester() != null) {
            elements.add(TelegramBotProcessor.createTelegramUser((HRModel)issue.getTester()));
        }
        if (issue.getPerformer() != null) {
            elements.add(TelegramBotProcessor.createTelegramUser((HRModel)issue.getPerformer()));
        }
        return Strings.arrayToCommaDelimitedString((Object[])elements.toArray());
    }

    private String generateTelegramChangesEdit(IssueModel original, IssueModel current, WebContext.LocalWebContext context) {
        StringBuilder issue = new StringBuilder();
        issue.append("<a href='").append(TelegramBotProcessor.getIssuePath((WebContext.LocalWebContext)context, (IssueModel)current)).append("'>").append("Issue: ID").append(current.getId()).append("</a>").append(" was changed: \n");
        if (Objects.equals(original.getName(), current.getName())) {
            issue.append("Name: ").append(current.getName()).append("\n");
        }
        issue.append("Attention to: ").append(this.generateAttentionUsers(current)).append("\n");
        StringBuilder changes = new StringBuilder();
        if (!Objects.equals(original.getName(), current.getName())) {
            changes.append("Name changed: from ").append(original.getName()).append(" to ").append(current.getName()).append("\n");
        }
        if (!Objects.equals(original.getDescription(), current.getDescription())) {
            changes.append("Description was changed").append("\n");
        }
        if (!Objects.equals(original.getGroup(), current.getGroup())) {
            changes.append("Group changed: from ").append(this.toStr((BaseEntity)original.getGroup())).append(" to ").append(this.toStr((BaseEntity)current.getGroup())).append("\n");
        }
        if (!Objects.equals(original.getPriority(), current.getPriority())) {
            changes.append("Priority changed: from ").append(this.toStr((BaseEntity)original.getPriority())).append(" to ").append(this.toStr((BaseEntity)current.getPriority())).append("\n");
        }
        if (!Objects.equals(original.getTester(), current.getTester())) {
            changes.append("Tester changed: from ").append(this.toStr((BaseEntity)original.getTester())).append(" to ").append(this.toStr((BaseEntity)current.getTester())).append("\n");
        }
        if (!Objects.equals(original.getPerformer(), current.getPerformer())) {
            changes.append("Performer changed: from ").append(this.toStr((BaseEntity)original.getPerformer())).append(" to ").append(this.toStr((BaseEntity)current.getPerformer())).append("\n");
        }
        if (!Objects.equals(original.getStatus(), current.getStatus())) {
            changes.append("Status changed: from ").append(this.toStr((BaseEntity)original.getStatus())).append(" to ").append(this.toStr((BaseEntity)current.getStatus())).append("\n");
        }
        if (!Objects.equals(original.getIssueFlow(), current.getIssueFlow())) {
            changes.append("Flow changed: from ").append(this.toStr((BaseEntity)original.getIssueFlow())).append(" to ").append(this.toStr((BaseEntity)current.getIssueFlow())).append("\n");
        }
        if (!Objects.equals(original.getFinishedOn(), current.getFinishedOn())) {
            if (original.getFinishedOn() == null) {
                changes.append("Finished changed: from ").append("Not set").append(" to ").append(TelegramBotProcessor.dateToString((Date)current.getFinishedOn())).append("\n");
            } else {
                changes.append("Finished changed: from ").append(original.getFinishedOn()).append(" to ").append(TelegramBotProcessor.dateToString((Date)current.getFinishedOn())).append("\n");
            }
        }
        if (!Objects.equals(original.getIcon(), current.getIcon())) {
            if (Objects.equals(current.getIcon(), "")) {
                changes.append("Screenshot: ").append("Not set").append("\n");
            } else {
                changes.append("Screenshot: ").append(current.getIcon()).append("\n");
            }
        }
        return changes.toString().isEmpty() ? null : issue.append((CharSequence)changes).append("Issue was changed by ").append(((HRService)context.getBean(HRService.class)).me().getName()).toString();
    }

    public static String createTelegramUser(HRModel id) {
        if (id == null) {
            return " ";
        }
        if (id.getTelegramName() == null || id.getTelegramName().isEmpty()) {
            return " " + id.getName() + " ";
        }
        return "@" + id.getTelegramName() + " ";
    }

    public String toStr(BaseEntity entity) {
        return entity == null ? " Not set" : entity.asValue();
    }

    public static String getIssuePath(WebContext.LocalWebContext context, IssueModel issue) {
        if (issue == null) {
            return "";
        }
        return String.valueOf(context.getEnv("app.settings.site.self.ui")) + "pages/issue/view/?id=" + issue.getId();
    }

    public static String dateToString(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss dd.MM.yyyy 'UTC'");
        return format.format(date);
    }
}

