/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service.personal_working_time;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.form.personal_working_time.WorkingTimeForm;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.personal_working_time.WorkingTimeModel;
import systems.dennis.flaw.repo.personal_working_time.WorkingTimeRepo;
import systems.dennis.flaw.service.GroupableService;
import systems.dennis.flaw.service.HRService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;

@Service
@DataRetrieverDescription(model=WorkingTimeModel.class, form=WorkingTimeForm.class, repo=WorkingTimeRepo.class)
public class WorkingTimeService
extends GroupableService<WorkingTimeModel> {
    private static final Logger log = LoggerFactory.getLogger(WorkingTimeService.class);

    public WorkingTimeService(WebContext holder) {
        super(holder);
    }

    public List<WorkingTimeModel> getAllByYearAndMonth(Integer year, Integer month, Long from, Integer limit, Integer page) {
        Date lastDatePrevMonth = this.getLastDateOfPrevMonth(year, month);
        Date firstDayNextMonth = this.getFirstDateOfNextMonth(year, month);
        log.info("-----getAllWorkingTimeByYearAndMonth from " + String.valueOf(lastDatePrevMonth) + " to " + String.valueOf(firstDayNextMonth) + " excluded");
        DefaultSearchSpecification spec = QueryCase.more((String)"date", (Object)lastDatePrevMonth).specification().addCase(QueryCase.less((String)"date", (Object)firstDayNextMonth));
        Page modelPages = this.find(spec, from, limit, page);
        return new ArrayList<WorkingTimeModel>(modelPages.getContent());
    }

    public List<WorkingTimeModel> getAllByYearAndMonthAndPersonId(Integer year, Integer month, Long personId, Long from, Integer limit, Integer page) {
        Date lastDatePrevMonth = this.getLastDateOfPrevMonth(year, month);
        Date firstDayNextMonth = this.getFirstDateOfNextMonth(year, month);
        HRModel person = (HRModel)((HRService)this.getBean(HRService.class)).findById(personId).orElseThrow(() -> new ItemNotFoundException(personId));
        log.info("-----getAllWorkingTimeByYearAndMonth by Person [" + person.getName() + "] from " + String.valueOf(lastDatePrevMonth) + " to " + String.valueOf(firstDayNextMonth) + " excluded");
        DefaultSearchSpecification spec = QueryCase.more((String)"date", (Object)lastDatePrevMonth).specification().addCase(QueryCase.less((String)"date", (Object)firstDayNextMonth)).addCase(QueryCase.equalsOf((String)"person", (Object)person));
        Page modelPages = this.find(spec, from, limit, page);
        return new ArrayList<WorkingTimeModel>(modelPages.getContent());
    }

    private Date getLastDateOfPrevMonth(Integer year, Integer month) {
        Calendar cal = Calendar.getInstance();
        month = month - 2;
        cal.set(year, month, 1, 23, 59, 59);
        cal.set(year, month, cal.getActualMaximum(5));
        return cal.getTime();
    }

    private Date getFirstDateOfNextMonth(Integer year, Integer month) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, 1, 0, 0, 0);
        return cal.getTime();
    }

    public WorkingTimeModel preAdd(WorkingTimeModel object) throws ItemForAddContainsIdException {
        super.assignGroup((BaseEntity)object);
        this.assignProject(object);
        this.assignEpic(object);
        this.assignStory(object);
        return (WorkingTimeModel)super.preAdd((BaseEntity)object);
    }

    public void assignProject(WorkingTimeModel model) {
        if (model == null) {
            return;
        }
        if (model.getProject() == null) {
            model.setProject(model.findInnerProject());
        }
    }

    public void assignEpic(WorkingTimeModel model) {
        if (model == null) {
            return;
        }
        if (model.getEpic() == null) {
            model.setEpic(model.findInnerEpic());
        }
    }

    public void assignStory(WorkingTimeModel model) {
        if (model == null) {
            return;
        }
        if (model.getStory() == null) {
            model.setStory(model.findInnerStory());
        }
    }

    public WorkingTimeRepo getRepository() {
        return (WorkingTimeRepo)super.getRepository();
    }
}

