/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service.sprint;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.exception.IssueFlowException;
import systems.dennis.flaw.exception.SprintFlowException;
import systems.dennis.flaw.form.SprintForm;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.SprintFlowModel;
import systems.dennis.flaw.model.SprintFlowStageModel;
import systems.dennis.flaw.model.SprintModel;
import systems.dennis.flaw.model.SprintStatusModel;
import systems.dennis.flaw.model.TeamInGroupModel;
import systems.dennis.flaw.model.TeamModel;
import systems.dennis.flaw.model.UserInTeamModel;
import systems.dennis.flaw.repo.SprintRepo;
import systems.dennis.flaw.service.GroupableService;
import systems.dennis.flaw.service.issue.ItemCounter;
import systems.dennis.flaw.service.sprint.AbstractSprintChangedProcess;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemNotFoundException;

@Service
@DataRetrieverDescription(model=SprintModel.class, form=SprintForm.class, repo=SprintRepo.class)
public class SprintService
extends GroupableService<SprintModel>
implements ItemCounter {
    @PersistenceContext(type=PersistenceContextType.EXTENDED)
    EntityManager em;

    public SprintService(WebContext holder) {
        super(holder);
    }

    public SprintModel promote(Long sprintId) {
        SprintModel sprint = (SprintModel)this.findByIdClone(sprintId).orElseThrow(() -> new ItemNotFoundException(sprintId));
        SprintFlowStageModel currentStage = this.getStageFromSprintFlowBySprintId(sprintId);
        SprintStatusModel nextStatus = currentStage.getNexStatus();
        if (nextStatus == null) {
            throw new IssueFlowException(sprintId, "flow_is_finished");
        }
        sprint.setStatus(nextStatus);
        return (SprintModel)this.save((BaseEntity)sprint);
    }

    public SprintModel demote(Long sprintId) {
        SprintModel sprint = (SprintModel)this.findByIdClone(sprintId).orElseThrow(() -> new ItemNotFoundException(sprintId));
        SprintFlowStageModel currentStage = this.getStageFromSprintFlowBySprintId(sprintId);
        SprintStatusModel prevStatus = currentStage.getPrevStatus();
        if (prevStatus == null) {
            throw new IssueFlowException(sprintId, "flow_is_on_the_start");
        }
        sprint.setStatus(prevStatus);
        return (SprintModel)this.save((BaseEntity)sprint);
    }

    public SprintFlowStageModel getStageFromSprintFlowBySprintId(Long sprintId) {
        SprintModel sprint = (SprintModel)this.getRepository().findById((Object)sprintId).orElseThrow(() -> new ItemNotFoundException(sprintId));
        SprintFlowModel flow = sprint.getSprintFlow();
        if (flow == null) {
            throw new SprintFlowException(sprintId, "no_flow_is_selected");
        }
        SprintStatusModel sprintStatus = sprint.getStatus();
        if (sprintStatus == null) {
            throw new SprintFlowException(sprintId, "sprint_status_is_undefined");
        }
        List stages = flow.getStages();
        if (stages == null || stages.size() == 0) {
            throw new SprintFlowException(sprintId, "stages_are_not_created");
        }
        SprintFlowStageModel currentStage = null;
        for (SprintFlowStageModel stage : stages) {
            if (!stage.getCurrentStatus().equals((Object)sprintStatus)) continue;
            currentStage = stage;
            break;
        }
        if (currentStage == null) {
            throw new SprintFlowException(sprintId, "flow_is_not_consist_stage_with_status_" + String.valueOf(sprintStatus));
        }
        return currentStage;
    }

    public SprintModel afterAdd(SprintModel object) {
        SprintModel res = AbstractSprintChangedProcess.runAll((SprintModel)object, null, (WebContext.LocalWebContext)this.getContext());
        this.getRepository().save((Object)res);
        return (SprintModel)super.afterAdd((BaseEntity)object);
    }

    public void afterEdit(SprintModel original, SprintModel current) {
        SprintModel res = AbstractSprintChangedProcess.runAll((SprintModel)original, (SprintModel)current, (WebContext.LocalWebContext)this.getContext());
        this.getRepository().save((Object)res);
    }

    public List<HRModel> getAllHrBySprint(SprintModel sprintModel) {
        GroupModel groupModel = sprintModel.getGroup();
        List teamInGroupModels = this.em.createQuery("from TeamInGroupModel u where u.group = :groupModel").setParameter("groupModel", (Object)groupModel).getResultList();
        HashSet<TeamModel> teams = new HashSet<TeamModel>();
        for (TeamInGroupModel teamInGroupModel : teamInGroupModels) {
            teams.add(teamInGroupModel.getTeam());
        }
        HashSet<HRModel> users = new HashSet<HRModel>();
        for (TeamModel team : teams) {
            List userInTeamModels = this.em.createQuery("from UserInTeamModel u where u.team = :team").setParameter("team", (Object)team).getResultList();
            for (UserInTeamModel userInTeamModel : userInTeamModels) {
                users.add(userInTeamModel.getModel());
            }
        }
        if (sprintModel.getCreator() != null) {
            users.add(sprintModel.getCreator());
        }
        return new ArrayList<HRModel>(users);
    }
}

