/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service.sprint.change_processors;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import systems.dennis.flaw.model.SprintFlowModel;
import systems.dennis.flaw.model.SprintFlowStageModel;
import systems.dennis.flaw.model.SprintModel;
import systems.dennis.flaw.model.SprintStatusModel;
import systems.dennis.flaw.service.sprint.AbstractSprintChangedProcess;
import systems.dennis.shared.config.WebContext;

public class SprintFinalDateProcessor
extends AbstractSprintChangedProcess {
    protected boolean run(SprintModel origin, SprintModel target, WebContext.LocalWebContext context) {
        if (!Objects.equals(target.getStatus(), origin.getStatus())) {
            if (this.isStatusLast(target)) {
                if (origin.getFinishedOn() == null) {
                    target.setFinishedOn(new Date());
                }
            } else if (target.getFinishedOn() != null) {
                target.setFinishedOn(null);
            }
        }
        return true;
    }

    public boolean shouldExecute(SprintModel origin, SprintModel target, WebContext.LocalWebContext context) {
        return target != null && target.getStatus() != null;
    }

    public boolean isStatusLast(SprintModel sprint) {
        SprintFlowModel flow = sprint.getSprintFlow();
        if (flow == null) {
            return false;
        }
        List stages = flow.getStages();
        SprintStatusModel status = sprint.getStatus();
        for (SprintFlowStageModel stageModel : stages) {
            if (stageModel.getNexStatus() != null || status != stageModel.getCurrentStatus()) continue;
            return true;
        }
        return false;
    }
}

