/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service.sprint.change_processors;

import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Component;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.SprintModel;
import systems.dennis.flaw.service.issue.change_processors.TelegramBotProcessor;
import systems.dennis.flaw.service.sprint.AbstractSprintChangedProcess;
import systems.dennis.flaw.service.sprint.SprintService;
import systems.dennis.flaw.user_notification.EmailNotificationChannel;
import systems.dennis.flaw.user_notification.WebNotificationChannel;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;

@Component
public class SprintNotificationProcessor
extends AbstractSprintChangedProcess {
    public static final String SPRINT_VIEW_URL = "pages/sprint/view/?id=";

    public boolean run(SprintModel origin, SprintModel target, WebContext.LocalWebContext context) {
        if (origin == null) {
            this.generateCreatedNotification(target, context);
        } else {
            this.generateUpdatedNotification(target, origin, context);
        }
        return true;
    }

    public boolean shouldExecute(SprintModel origin, SprintModel target, WebContext.LocalWebContext context) {
        if (origin != null && target != null) {
            return !origin.equals((Object)target);
        }
        return true;
    }

    private void generateCreatedNotification(SprintModel object, WebContext.LocalWebContext context) {
        List usersToNotification = ((SprintService)context.getBean(SprintService.class)).getAllHrBySprint(object);
        HashMap<CallSite, String> data = new HashMap<CallSite, String>();
        for (HRModel user : usersToNotification) {
            String userLanguage = user.getDefLanguage();
            data.put((CallSite)((Object)("title_" + userLanguage)), context.getMessageTranslation("app.sprint.config.email.sprint.created", userLanguage));
            data.put((CallSite)((Object)("content_" + userLanguage)), this.generateCreatedNotificationContent(object, context, userLanguage));
            ((EmailNotificationChannel)context.getBean(EmailNotificationChannel.class)).generate(data, "sprint_created.html", user);
            ((WebNotificationChannel)context.getBean(WebNotificationChannel.class)).generate(data, "sprint_created.html", user);
        }
    }

    private void generateUpdatedNotification(SprintModel object, SprintModel original, WebContext.LocalWebContext context) {
        List usersToNotification = ((SprintService)context.getBean(SprintService.class)).getAllHrBySprint(object);
        HashMap<CallSite, String> data = new HashMap<CallSite, String>();
        for (HRModel user : usersToNotification) {
            String userLanguage = user.getDefLanguage();
            data.put((CallSite)((Object)("title_" + userLanguage)), context.getMessageTranslation("app.sprint.config.email.sprint.edited", userLanguage));
            data.put((CallSite)((Object)("content_" + userLanguage)), this.generateUpdatedNotificationContent(object, original, context, userLanguage));
            ((EmailNotificationChannel)context.getBean(EmailNotificationChannel.class)).generate(data, "sprint_updated.html", user);
            ((WebNotificationChannel)context.getBean(WebNotificationChannel.class)).generate(data, "sprint_updated.html", user);
        }
    }

    private String generateCreatedNotificationContent(SprintModel model, WebContext.LocalWebContext context, String lang) {
        StringBuilder content = new StringBuilder();
        String sprintLink = "<a href=\"" + String.valueOf(context.getEnv("app.settings.site.self.ui")) + SPRINT_VIEW_URL + model.getId() + "\">ID" + model.getId() + "</a> \n";
        return content.append("<p>").append(String.format(context.getMessageTranslation("app.message.created.sprint", lang), sprintLink)).append("</p>").append(this.appendField("group", lang, (BaseEntity)model.getGroup(), context)).append(this.appendField("project", lang, (BaseEntity)model.getProject(), context)).append(this.appendField("project_version", lang, (BaseEntity)model.getProjectVersion(), context)).append(this.appendField("status", lang, (BaseEntity)model.getStatus(), context)).append(this.appendField("all_tasks_status", lang, (BaseEntity)model.getAll_tasks_status(), context)).append(this.appendField("sprint_flow", lang, (BaseEntity)model.getSprintFlow(), context)).append(this.appendDateField("start", lang, model.getStart(), context)).append(this.appendDateField("finish", lang, model.getFinish(), context)).toString();
    }

    private String appendField(String key, String lang, BaseEntity value, WebContext.LocalWebContext context) {
        String messageKey = "app.sprint.message.created." + key;
        return "<p>" + context.getMessageTranslation(messageKey, lang) + this.toStr(value) + "</p>";
    }

    private String appendDateField(String key, String lang, Date date, WebContext.LocalWebContext context) {
        String messageKey = "app.sprint.message.created." + key;
        return "<p>" + context.getMessageTranslation(messageKey, lang) + TelegramBotProcessor.dateToString((Date)date) + "</p>";
    }

    private String generateUpdatedNotificationContent(SprintModel object, SprintModel original, WebContext.LocalWebContext context, String lang) {
        StringBuilder content = new StringBuilder();
        String sprintLink = "<a href=\"" + String.valueOf(context.getEnv("app.settings.site.self.ui")) + SPRINT_VIEW_URL + object.getId() + "\">ID" + object.getId() + "</a>";
        content.append("<p>").append(String.format(context.getMessageTranslation("app.sprint.message.edited.sprint", lang), sprintLink)).append("</p>").append(this.appendChange("group", (BaseEntity)original.getGroup(), (BaseEntity)object.getGroup(), context, lang)).append(this.appendChange("project", (BaseEntity)original.getProject(), (BaseEntity)object.getProject(), context, lang)).append(this.appendChange("project_version", (BaseEntity)original.getProjectVersion(), (BaseEntity)object.getProjectVersion(), context, lang)).append(this.appendChange("status", (BaseEntity)original.getStatus(), (BaseEntity)object.getStatus(), context, lang)).append(this.appendChange("all_tasks_status", (BaseEntity)original.getAll_tasks_status(), (BaseEntity)object.getAll_tasks_status(), context, lang)).append(this.appendChange("sprint_flow", (BaseEntity)original.getSprintFlow(), (BaseEntity)object.getSprintFlow(), context, lang)).append(this.appendDateChange("finished_on", original.getFinishedOn(), object.getFinishedOn(), context, lang)).append(this.appendDateChange("start", original.getStart(), object.getStart(), context, lang)).append(this.appendDateChange("finish", original.getFinish(), object.getFinish(), context, lang));
        return content.toString();
    }

    private String appendChange(String key, BaseEntity originalValue, BaseEntity newValue, WebContext.LocalWebContext context, String lang) {
        StringBuilder change = new StringBuilder();
        if (!Objects.equals(originalValue, newValue)) {
            String messageKey = "app.sprint.message.edited." + key;
            String changeMessage = context.getMessageTranslation(messageKey, lang);
            change.append("<p>").append(String.format(changeMessage, this.toStr(originalValue), this.toStr(newValue))).append("</p>");
        }
        return change.length() > 0 ? change.toString() : "";
    }

    private String appendDateChange(String key, Date originalValue, Date newValue, WebContext.LocalWebContext context, String lang) {
        StringBuilder change = new StringBuilder();
        if (originalValue != null && newValue != null && originalValue.compareTo(newValue) == 0) {
            return "";
        }
        if (!Objects.equals(originalValue, newValue)) {
            String messageKey = "app.sprint.message.edited." + key;
            String changeMessage = context.getMessageTranslation(messageKey, lang);
            change.append("<p>").append(String.format(changeMessage, this.dateToString(originalValue), this.dateToString(newValue))).append("</p>");
        }
        return change.length() > 0 ? change.toString() : "";
    }

    public String toStr(BaseEntity hr) {
        return hr == null ? " Not set " : hr.asValue();
    }

    public String dateToString(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
        if (date == null) {
            return "Not set";
        }
        return format.format(date);
    }
}

