/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service.sprint.change_processors;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import systems.dennis.flaw.bean.TelegramBotBean;
import systems.dennis.flaw.model.SprintModel;
import systems.dennis.flaw.service.sprint.AbstractSprintChangedProcess;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;

/*
 * Exception performing whole class analysis ignored.
 */
public class SprintTelegramBotProcessor
extends AbstractSprintChangedProcess {
    public static final String SPRINT_VIEW_URL = "pages/sprint/view/?id=";

    public boolean run(SprintModel origin, SprintModel target, WebContext.LocalWebContext context) {
        String text;
        String string = text = origin == null ? this.generateTelegramChangesAdd(target, context) : this.generateTelegramChangesEdit(origin, target, context);
        if (text != null) {
            ((TelegramBotBean)context.getBean(TelegramBotBean.class)).sendMessage(target.getGroup(), text);
        }
        return true;
    }

    public boolean shouldExecute(SprintModel origin, SprintModel target, WebContext.LocalWebContext context) {
        return this.isTelegramBotActive(target, context) && this.isModelDifferent(origin, target);
    }

    private boolean isTelegramBotActive(SprintModel target, WebContext.LocalWebContext context) {
        return ((TelegramBotBean)context.getBean(TelegramBotBean.class)).isActive() && target.getGroup().getTelegramId() != null && target.getGroup().getTelegramId() != 0L;
    }

    private boolean isModelDifferent(SprintModel origin, SprintModel target) {
        if (origin != null && target != null) {
            return !origin.equals((Object)target);
        }
        return true;
    }

    private String generateTelegramChangesAdd(SprintModel current, WebContext.LocalWebContext context) {
        StringBuffer sprint = new StringBuffer();
        sprint.append("<a href='").append(SprintTelegramBotProcessor.getIssuePath((WebContext.LocalWebContext)context, (SprintModel)current)).append("'>Sprint: ID").append(current.getId()).append("</a> was created! \n");
        sprint.append("Project: ").append(this.toStr((BaseEntity)current.getProject())).append("\n");
        StringBuilder changes = new StringBuilder();
        changes.append("Project version: ").append(this.toStr((BaseEntity)current.getProjectVersion())).append("\n");
        changes.append("Status: ").append(this.toStr((BaseEntity)current.getStatus())).append("\n");
        changes.append("Start: ").append(SprintTelegramBotProcessor.dateToString((Date)current.getStart())).append("\n");
        changes.append("Finish: ").append(SprintTelegramBotProcessor.dateToString((Date)current.getFinish())).append("\n");
        return changes.toString().isEmpty() ? null : sprint.append((CharSequence)changes).toString();
    }

    private String generateTelegramChangesEdit(SprintModel original, SprintModel current, WebContext.LocalWebContext context) {
        StringBuffer sprint = new StringBuffer();
        sprint.append("<a href='").append(SprintTelegramBotProcessor.getIssuePath((WebContext.LocalWebContext)context, (SprintModel)current)).append("'>Sprint: ID").append(current.getId()).append("</a> was changed! \n");
        StringBuilder changes = new StringBuilder();
        if (!Objects.equals(original.getProject(), current.getProject())) {
            changes.append("Project changed: from ").append(this.toStr((BaseEntity)original.getProject())).append(" to ").append(this.toStr((BaseEntity)current.getProject())).append("\n");
        }
        if (!Objects.equals(original.getProjectVersion(), current.getProjectVersion())) {
            changes.append("Project version changed: from ").append(this.toStr((BaseEntity)original.getProjectVersion())).append(" to ").append(this.toStr((BaseEntity)current.getProjectVersion())).append("\n");
        }
        if (!Objects.equals(original.getDescription(), current.getDescription())) {
            changes.append("Description was changed").append("\n");
        }
        if (!Objects.equals(original.getGroup(), current.getGroup())) {
            changes.append("Group changed: from ").append(this.toStr((BaseEntity)original.getGroup())).append(" to ").append(this.toStr((BaseEntity)current.getGroup())).append("\n");
        }
        if (!Objects.equals(original.getAll_tasks_status(), current.getAll_tasks_status())) {
            changes.append("All tasks status changed: from ").append(this.toStr((BaseEntity)original.getAll_tasks_status())).append(" to ").append(this.toStr((BaseEntity)current.getAll_tasks_status())).append("\n");
        }
        if (!Objects.equals(original.getStatus(), current.getStatus())) {
            changes.append("Status changed: from ").append(this.toStr((BaseEntity)original.getStatus())).append(" to ").append(this.toStr((BaseEntity)current.getStatus())).append("\n");
        }
        if (!Objects.equals(original.getSprintFlow(), current.getSprintFlow())) {
            changes.append("Flow changed: from ").append(this.toStr((BaseEntity)original.getSprintFlow())).append(" to ").append(this.toStr((BaseEntity)current.getSprintFlow())).append("\n");
        }
        if (original.getStart().compareTo(current.getStart()) != 0) {
            changes.append("Start changed: from ").append(SprintTelegramBotProcessor.dateToString((Date)original.getStart())).append(" to ").append(SprintTelegramBotProcessor.dateToString((Date)current.getStart())).append("\n");
        }
        if (original.getFinish().compareTo(current.getFinish()) != 0) {
            changes.append("Finish changed: from ").append(SprintTelegramBotProcessor.dateToString((Date)original.getFinish())).append(" to ").append(SprintTelegramBotProcessor.dateToString((Date)current.getFinish())).append("\n");
        }
        return sprint.append((CharSequence)changes).toString();
    }

    public String toStr(BaseEntity entity) {
        return entity == null ? " Not set" : entity.asValue();
    }

    public static String getIssuePath(WebContext.LocalWebContext context, SprintModel sprint) {
        if (sprint == null) {
            return "";
        }
        return String.valueOf(context.getEnv("app.settings.site.self.ui")) + "pages/sprint/view/?id=" + sprint.getId();
    }

    public static String dateToString(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
        return format.format(date);
    }
}

