/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.user_notification;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.NotificationDeliveryModel;
import systems.dennis.flaw.model.UserNotificationModel;
import systems.dennis.flaw.service.UserNotificationService;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.utils.ApplicationContext;

public abstract class AbstractUserNotificationChannel
extends ApplicationContext {
    private static final Logger log = LoggerFactory.getLogger(AbstractUserNotificationChannel.class);
    private final UserNotificationService userNotificationService;

    public AbstractUserNotificationChannel(WebContext context, UserNotificationService userNotificationService) {
        super(context);
        this.userNotificationService = userNotificationService;
    }

    public UserNotificationService getUserNotificationService() {
        return this.userNotificationService;
    }

    public abstract NotificationDeliveryModel generate(Map<String, Object> var1, String var2, HRModel var3);

    public void startDelivery(UserNotificationModel model) {
        try {
            if (this.isActive()) {
                this.deliver(model);
            }
        }
        catch (Exception e) {
            log.error("Cannot deliver notification to user: " + String.valueOf(model));
        }
    }

    public abstract boolean isActive();

    public abstract boolean deliver(UserNotificationModel var1);
}

