/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.user_notification;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.mail.MailSender;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.NotificationDeliveryModel;
import systems.dennis.flaw.model.UserNotificationModel;
import systems.dennis.flaw.repo.NotificationDeliveryRepo;
import systems.dennis.flaw.service.ChannelSettingService;
import systems.dennis.flaw.service.UserNotificationService;
import systems.dennis.flaw.user_notification.AbstractUserNotificationChannel;
import systems.dennis.shared.config.WebContext;

@Service
public class EmailNotificationChannel
extends AbstractUserNotificationChannel {
    private static final Logger log = LoggerFactory.getLogger(EmailNotificationChannel.class);
    public static final String EMAIL_TEMPLATE_TITLE = "title_";
    public static final String EMAIL_TEMPLATE_CONTENT = "content_";
    public static final String EMAIL_TEMPLATE_LANG = "lang";
    public static final int EMAIL_CHANNEL = 0;

    public EmailNotificationChannel(WebContext context, UserNotificationService userNotificationService) {
        super(context, userNotificationService);
    }

    public boolean isActive() {
        return ((ChannelSettingService)this.getUserNotificationService().getBean(ChannelSettingService.class)).getMy().getAllowEmail();
    }

    public boolean deliver(UserNotificationModel model) {
        return false;
    }

    public NotificationDeliveryModel generate(Map<String, Object> data, String template, HRModel hr) {
        String lang = hr.getDefLanguage();
        NotificationDeliveryModel notificationDeliveryModel = new NotificationDeliveryModel();
        notificationDeliveryModel.setChannel(0);
        notificationDeliveryModel.setTitle(String.valueOf(data.get(EMAIL_TEMPLATE_TITLE + lang)));
        notificationDeliveryModel.setLang(lang);
        notificationDeliveryModel.setHr(hr);
        notificationDeliveryModel.setDelivered(Boolean.valueOf(false));
        String path = "email/" + lang + "/" + template;
        String templateContent = ((MailSender)this.getContext().getBean(MailSender.class)).processHtmlTemplate(path, data);
        notificationDeliveryModel.setText(templateContent.replace("{{content}}", String.valueOf(data.get(EMAIL_TEMPLATE_CONTENT + lang))));
        NotificationDeliveryModel savedNotificationDelivery = new NotificationDeliveryModel();
        if (this.isActive()) {
            savedNotificationDelivery = (NotificationDeliveryModel)((NotificationDeliveryRepo)this.getContext().getBean(NotificationDeliveryRepo.class)).save((Object)notificationDeliveryModel);
        }
        return savedNotificationDelivery;
    }
}

