/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.user_notification;

import java.util.Date;
import java.util.Map;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.mail.MailSender;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.NotificationDeliveryModel;
import systems.dennis.flaw.model.UserNotificationModel;
import systems.dennis.flaw.repo.NotificationDeliveryRepo;
import systems.dennis.flaw.repo.UserNotificationRepo;
import systems.dennis.flaw.service.ChannelSettingService;
import systems.dennis.flaw.service.NotificationDeliveryService;
import systems.dennis.flaw.service.UserNotificationService;
import systems.dennis.flaw.user_notification.AbstractUserNotificationChannel;
import systems.dennis.shared.config.WebContext;

@Service
public class WebNotificationChannel
extends AbstractUserNotificationChannel {
    public static final String WEB_TEMPLATE_TITLE = "title_";
    public static final String WEB_TEMPLATE_LANG = "lang";
    public static final int WEB_CHANNEL = 1;

    public WebNotificationChannel(WebContext context, UserNotificationService userNotificationService) {
        super(context, userNotificationService);
    }

    public boolean isActive() {
        return ((ChannelSettingService)this.getUserNotificationService().getBean(ChannelSettingService.class)).getMy().getAllowWeb();
    }

    public boolean deliver(UserNotificationModel model) {
        ((UserNotificationRepo)this.getContext().getBean(UserNotificationRepo.class)).save((Object)model);
        return true;
    }

    public NotificationDeliveryModel generate(Map<String, Object> data, String template, HRModel hr) {
        String lang = hr.getDefLanguage();
        NotificationDeliveryModel notificationDeliveryModel = new NotificationDeliveryModel();
        notificationDeliveryModel.setChannel(1);
        notificationDeliveryModel.setTitle(String.valueOf(data.get(WEB_TEMPLATE_TITLE + lang)));
        notificationDeliveryModel.setLang(lang);
        notificationDeliveryModel.setHr(hr);
        notificationDeliveryModel.setDelivered(Boolean.valueOf(false));
        notificationDeliveryModel.setDeliveredDate(new Date());
        String path = "web/" + lang + "/" + template;
        String templateContent = ((MailSender)this.getContext().getBean(MailSender.class)).processHtmlTemplate(path, data);
        notificationDeliveryModel.setText(templateContent.replace("{{content}}", String.valueOf(data.get("content_" + lang))));
        NotificationDeliveryModel savedNotificationDelivery = (NotificationDeliveryModel)((NotificationDeliveryRepo)this.getContext().getBean(NotificationDeliveryRepo.class)).save((Object)notificationDeliveryModel);
        UserNotificationModel userNotificationModel = this.generateNotification(savedNotificationDelivery);
        this.startDelivery(userNotificationModel);
        ((NotificationDeliveryService)this.getContext().getBean(NotificationDeliveryService.class)).changeNotificationStatus(savedNotificationDelivery);
        return savedNotificationDelivery;
    }

    private UserNotificationModel generateNotification(NotificationDeliveryModel notificationDelivery) {
        UserNotificationModel model = new UserNotificationModel();
        model.setTitle(notificationDelivery.getTitle());
        model.setText(notificationDelivery.getText());
        model.setIsRead(Boolean.valueOf(false));
        model.setRecipient(notificationDelivery.getHr());
        return model;
    }
}

