/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.validation;

import systems.dennis.flaw.form.IssueForm;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.TeamInGroupService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.pojo_form.ValidationResult;
import systems.dennis.shared.validation.ValueValidator;

public class IssueCreatorBelongGroupValidator
implements ValueValidator {
    public ValidationResult validate(Class serviceClass, Object element, String field, Object value, boolean edit, WebContext.LocalWebContext context) {
        if (edit) {
            IssueForm issueForm = (IssueForm)element;
            GroupModel group = (GroupModel)((GroupService)context.getBean(GroupService.class)).findById(issueForm.getGroup()).orElseThrow(() -> new ItemNotFoundException(issueForm.getId()));
            IssueModel issueModel = (IssueModel)((IssueService)context.getBean(IssueService.class)).findByIdOrThrow(issueForm.getId());
            return ((TeamInGroupService)context.getBean(TeamInGroupService.class)).isHrAssignedToGroup(issueModel.getCreator(), group) ? ValidationResult.PASSED : ValidationResult.fail((String)"issue_creator_not_belong_to_new_group");
        }
        return ValidationResult.PASSED;
    }
}

