create or replace view public.issue_created_view(id, count, name, group_id, date, hidden) as
SELECT floor(random() * 999999::double precision)::integer AS id,
       count(0)                                            AS count,
       group_model.name                                    AS name,
       group_model.id                                      AS group_id,
       date_trunc('day'::text, issue_model.created)        AS date,
       false                                               as hidden
FROM issue_model,
     group_model
WHERE issue_model.group_id = group_model.id
  AND issue_model.created > date_trunc('day'::text, now() - '1 mon'::interval)
GROUP BY issue_model.created, group_model.id, group_model.name;

alter table public.issue_created_view
    owner to postgres;



alter table public.issue_created_view
    owner to postgres;

create or replace view public.issue_status_view(id, count, name, group_id, hidden) as
SELECT floor(random() * 99999::double precision)::integer AS id,
       count(0)                                           AS count,
       issue_status_model.name                            AS NAME,
       issue_model.group_id                               as group_id,
       false                                              as hidden
FROM issue_model,
     issue_status_model
WHERE issue_model.status_id = issue_status_model.id
GROUP BY issue_status_model.name, issue_model.group_id;

alter table public.issue_status_view
    owner to postgres;

create or replace view sprint_progress_view as
select floor(random() * 999999)::int                                                               AS id,
       x.id                                                                                        as sprint_id,
       (select count(0) from issue_model m where x.id = m.sprint_id)                               as total,
       (select count(0) from issue_model m where x.id = m.sprint_id and m.finished_on is not null) as finished
from sprint_model x;

CREATE or replace FUNCTION getAmount(groupId BIGINT, projectId BIGINT, hrId BIGINT, year DOUBLE PRECISION, month DOUBLE PRECISION,
                                     isNullProjectCheck bool) RETURNS integer
    language plpgsql AS
$$
declare
    item integer;
    sql  text := 'SELECT sum(amount) as amount FROM work_log_model where true ';
    res  RECORD;
BEGIN
    if groupId IS NOT NULL THEN
        BEGIN
            sql := sql || ' and group_id=' || groupId;
        end;

    END if;


    if projectId IS NOT NULL THEN
        BEGIN
            sql := sql || ' and project_id=' || projectId;
        end;

    ELSE
        BEGIN
            if isNullProjectCheck then
                BEGIN

                    sql := sql || ' and project_id is null ';
                end;
            end if;
        end;
    END if;
    if hrId IS NOT NULL THEN
        BEGIN
            sql := sql || ' and hr_id=' || hrId;
        end;
    END if;

    sql := sql || ' and EXTRACT(MONTH FROM date) = ' || month;
    sql := sql || ' and EXTRACT(YEAR FROM date)  = ' || year;

    EXECUTE sql USING groupId, projectId, hrId into RES;
    return res.amount;


end ;
$$;

create or replace view user_work_log_report as
(
select m.group_id,
       floor(random() * 999999::double precision)::integer                                                AS id,
       m.project_id,
       getAmount(m.group_id, m.project_id, m.hr_id, extract(YEAR from m.date), extract(MONTH from m.date),
                 true)                                                                                    as hr_sum_in_project,
       getAmount(m.group_id, null, m.hr_id, extract(YEAR from m.date),
                 extract(MONTH from m.date), false)                                                       as hr_sum_in_group,
       getAmount(null, null, m.hr_id, extract(YEAR from m.date), extract(MONTH from m.date), false)       as hr_sum,
       getAmount(m.group_id, null, null, extract(YEAR from m.date), extract(MONTH from m.date), false)    as group_sum,
       getAmount(m.group_id, m.project_id, null, extract(YEAR from m.date),
                 extract(MONTH from m.date), true)                                                        as sum_in_project,
       m.hr_id,
       EXTRACT(MONTH FROM m.date)                                                                         as month,
       EXTRACT(YEAR FROM m.date)                                                                          as year

from work_log_model m
group by group_id, project_id, hr_id, m.date order by group_id, project_id, hr_id)

